<?php
defined('IN_MET') or exit ('No permission');
load::sys_class('admin');
load::sys_func('file');
class install extends admin
{

    public function __construct()
    {
        global $_M;
        parent::__construct();
        $this->version = '7.6';
    }

    public function dosql()
    {
        global $_M;
        $this->update_system($this->version);

        $arr = explode('/', trim($_M['url']['site_admin'], '/'));
        $admin_dir = array_pop($arr);
        $admin_lock = PATH_WEB . "{$admin_dir}/admin.lock";
        file_put_contents($admin_lock, 'admin_dir');

        //清除缓存
        deldir('upload/thumb_src', 1);
        deldir('cache', 1);

        //用户协议文件
        @unlink(PATH_WEB . 'upload/file/license.html');
    }

    public function update_system($version)
    {
        global $_M;
        //更新版本号
        $this->update_ver($version);
        $this->updataLogs('update_ver');

        switch (strtolower($_M['config']['db_type'])) {
            case 'mysql':
                //检测新增数据表和字段
                $this->diff_fields($version);
                $this->updataLogs('diff_fields');
                //更新表字段默认值
                $this->alter_table($version);
                $this->updataLogs('alter_table');
                break;
            case 'sqlite':
                $this->databack_sqlite();
                $this->updataLogs('databack_sqlite');
                $this->add_table_sqlite();
                $this->updataLogs('add_table_sqlite');
                break;
            case 'dmsql':
                break;
        }

        //注册数据表
        $this->table_regist();
        $this->updataLogs('table_regist');

        //添加配置
        $this->add_config();
        $this->updataLogs('add_config');

        //配置变更
        $this->modify_config();
        $this->updataLogs('modify_config');

        //更新语言
        $this->update_language($version);
        $this->updataLogs('update_language');

        //删除系统冗余文件
        $this->del_sys_file();
        $this->updataLogs('del_sys_file');

        return;
    }

    /**
     * 升级日志
     * @param string $action
     */
    public function updataLogs($action = '')
    {
        file_put_contents(PATH_WEB . 'update_logs.log', "{$action}\n", FILE_APPEND);
    }

    /**
     * 更新版本号
     * @param string $version
     */
    public function update_ver($version = '')
    {
        global $_M;
        $query = "UPDATE {$_M['table']['config']} SET value = '{$version}' WHERE name = 'metcms_v'";
        DB::query($query);
        return;
    }

    /**
     * 对比数据库机构
     * @param $version
     */
    public function diff_fields($version)
    {
        global $_M;
        $diffs = self::get_diff_tables();
        if (isset($diffs['table'])) {
            foreach ($diffs['table'] as $table => $detail) {
                $sql = "CREATE TABLE IF NOT EXISTS `{$table}` (";
                foreach ($detail as $k => $v) {
                    if ($k == 'id') {
                        $sql .= "`{$k}` {$v['Type']} {$v['Extra']} ,";
                    } else {
                        $sql .= "`{$k}` {$v['Type']}  ";
                        if ($v['Default'] === null) {
                            $sql .= " DEFAULT NULL ";
                        } else {
                            $sql .= " DEFAULT '{$v['Default']}' ";
                        }
                        $sql .= " {$v['Extra']} ,";
                    }
                }
                $sql .= "PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;";
                DB::query($sql);
                add_table(str_replace($_M['config']['tablepre'], '', $table));
            }
        }

        if (isset($diffs['field'])) {
            foreach ($diffs['field'] as $table => $v) {
                foreach ($v as $field => $f) {
                    $sql = "ALTER TABLE `{$table}` ADD COLUMN `{$field}`  {$f['Type']} ";

                    if ($f['Default'] === null) {
                        $sql .= " DEFAULT NULL ";
                    } else {
                        $sql .= " DEFAULT '{$f['Default']}' ";
                    }

                    DB::query($sql);
                }
            }
        }
    }

    /**
     * 更新表字段默认值
     * @param $version
     */
    public function alter_table()
    {
        global $_M;
        $base = self::get_base_table();
        foreach ($base as $table_name => $table) {
            $table_name_now = str_replace('met_', $_M['config']['tablepre'], $table_name);
            $sql = "ALTER TABLE `{$table_name_now}` ";
            foreach ($table as $key => $field) {
                if ($key == 'id') {
                    continue;
                }

                $sql .= " MODIFY COLUMN `{$field['Field']}` {$field['Type']} ";
                if ($field['Default'] === null) {
                    $sql .= " DEFAULT NULL ";
                } else {
                    $sql .= " DEFAULT '{$field['Default']}' ";
                }
                $sql .= ',';
            }
            $sql = trim($sql, ',') . ';';
            DB::query($sql);
        }
    }

    /**
     * 备份sqlite数据库文件
     */
    public function databack_sqlite()
    {
        global $_M;
        $date = date("YmdHis");
        $new_path = PATH_WEB . "config/{$_M['config']['metcms_v']}_{$date}_" . random(5) . '.db';
        $db_path = PATH_WEB . $_M['config']['db_name'];
        if (file_exists($db_path)) {
            copyfile($db_path, $new_path);
        }
    }

    /**
     * sqlite 新增数表字段
     */
    public function add_table_sqlite()
    {
        global $_M;

        global $_M;
        $date = date("Ymd");

        //dowload table
        $temp_table_name = "met_download_old_{$date}";
        $table_name = $_M['table']['download'];
        $sql = "ALTER TABLE {$_M['table']['download']} RENAME TO '{$temp_table_name}'";
        DB::query($sql);

        $sql = "CREATE TABLE {$table_name} (
  id integer NOT NULL PRIMARY KEY AUTOINCREMENT,
  title text(200) DEFAULT '',
  ctitle text(200) DEFAULT '',
  keywords text(200) DEFAULT '',
  description text,
  content longtext,
  class1 integer(11) DEFAULT '0',
  class2 integer(11) DEFAULT '0',
  class3 integer(11) DEFAULT '0',
  no_order integer(11) DEFAULT '0',
  new_ok integer(1) DEFAULT '0',
  wap_ok integer(1) DEFAULT '0',
  imgurl text(255),
  downloadurl text(255) DEFAULT '',
  filesize text(100) DEFAULT '',
  com_ok integer(1) DEFAULT '0',
  hits integer(11) DEFAULT '0',
  updatetime datetime DEFAULT NULL,
  addtime datetime DEFAULT NULL,
  issue text(100) DEFAULT '',
  access text,
  top_ok integer(1) DEFAULT '0',
  downloadaccess text,
  filename text(255) DEFAULT '',
  lang text(50) DEFAULT '',
  recycle integer(11) NOT NULL DEFAULT '0',
  displaytype integer(11) NOT NULL DEFAULT '1',
  tag text,
  links text(200) DEFAULT '',
  text_size integer(11) DEFAULT '0',
  text_color text(100) DEFAULT '',
  other_info text,
  custom_info text
)";
        DB::query($sql);

        $sql = "SELECT * FROM {$temp_table_name}";
        $one = DB::get_one($sql);
        if ($one) {
            $sql = "INSERT INTO {$table_name} (id, title, ctitle, keywords, description, content, class1, class2, class3, no_order, new_ok, wap_ok, downloadurl, filesize, com_ok, hits, updatetime, addtime, issue, access, top_ok, downloadaccess, filename, lang, recycle, displaytype, tag, links, text_size, text_color, other_info, custom_info) SELECT id, title, ctitle, keywords, description, content, class1, class2, class3, no_order, new_ok, wap_ok, downloadurl, filesize, com_ok, hits, updatetime, addtime, issue, access, top_ok, downloadaccess, filename, lang, recycle, displaytype, tag, links, text_size, text_color, other_info, custom_info FROM {$temp_table_name}";
            DB::query($sql);
        }
        $sql = "DROP TABLE {$temp_table_name}";
        DB::query($sql);


        //relation table
        $table_name = $table_name = "{$_M['config']['tablepre']}relation";
        $sql = "CREATE TABLE {$table_name} (
  id integer NOT NULL PRIMARY KEY AUTOINCREMENT,
  aid integer(11) DEFAULT '0' ,
  module integer(11) DEFAULT '0',
  relation_id integer(11) DEFAULT '0' ,
  relation_module integer(11) DEFAULT '0',
  lang text(50) DEFAULT ''
)";
        DB::query($sql);
    }

    /**
     * 注册数据表
     */
    public function table_regist()
    {
        global $_M;
        add_table('admin_array|admin_column|admin_logs|admin_table|app_config|app_plugin|applist|column|config|cv|download|feedback|flash|flash_button|flist|ifcolumn|ifcolumn_addfile|ifmember_left|img|infoprompt|job|label|lang|lang_admin|language|link|menu|message|mlist|news|online|otherinfo|para|parameter|plist|product|relation|skin_table|tags|templates|ui_config|ui_list|user|user_group|user_group_pay|user_list|user_other|weixin_reply_log');
    }

    /**
     * 新增系统配置
     */
    public function add_config()
    {
        global $_M;
        foreach (array_keys($_M['langlist']['web']) as $lang) {
            //用户设置
            self::_insert_config('met_new_registe_email_notice', '', 0, $lang);
            self::_insert_config('met_to_admin_email', '', 0, $lang);
            self::_insert_config('met_new_registe_sms_notice', '', 0, $lang);
            self::_insert_config('met_to_admin_sms', '', 0, $lang);
            self::_insert_config('met_google_open', '', 0, $lang);
            self::_insert_config('met_google_appid', '', 0, $lang);
            self::_insert_config('met_google_appsecret', '', 0, $lang);
            self::_insert_config('met_facebook_open', '', 0, $lang);
            self::_insert_config('met_facebook_appid', '', 0, $lang);
            self::_insert_config('met_facebook_appsecret', '', 0, $lang);
            //水印图设置
            self::_insert_config('met_wate_img_scale', '0', 0, $lang);
            self::_insert_config('met_wate_img_gif_hold', '0', 0, $lang);
            //信息安全声明
            self::_insert_config('met_info_security_statement_open', '0', 0, $lang);
            self::_insert_config('met_info_security_statement_title', '', 0, $lang);
            self::_insert_config('met_info_security_statement_content', '', 0, $lang);
            self::_insert_config('met_info_security_statement_modal_title', '', 0, $lang);
            //静态页设置
            self::_insert_config('met_html_auto', '0', 0, $lang);
        }

        //global
        //self::_update_config('met_copyright_type', '0', 0, 'metinfo');
    }

    /**
     * 更新系统配置
     */
    public function modify_config()
    {
        global $_M;
        return;
        //self::_update_config('met_copyright_type', '0', 0, 'metinfo');
    }

    /**
     * 更新语言
     */
    public function update_language($version)
    {
        self::update_admin_lang($version);
        self::update_web_lang($version);
    }

    /**
     * 更新后台语言
     * @param $version
     */
    public function update_admin_lang($version)
    {
        global $_M;
        //添加管理员语言
        $query = "SELECT * FROM {$_M['table']['lang_admin']} WHERE lang = 'cn' AND mark = 'cn'";
        $res = DB::get_one($query);
        if (!$res) {
            $query = "INSERT INTO {$_M['table']['lang_admin']} SET name = '简体中文', useok = 1, no_order = 1, mark = 'cn', synchronous = 'cn',  link = '', lang = 'cn' ";
            DB::query($query);
        }

        //后台语言指纹
        $path_cn = PATH_WEB . "app/system/update/include/class/v{$version}lang_admin_cn.json";
        $path_en = PATH_WEB . "app/system/update/include/class/v{$version}lang_admin_en.json";
        //$lang_json_cn = "https://www.metinfo.cn/upload/json/v{$version}lang_cn.json";
        //$lang_json_en = "https://www.metinfo.cn/upload/json/v{$version}lang_en.json";

        $sql = "SELECT * FROM {$_M['table']['lang_admin']} ";
        $admin_lang_list = DB::get_all($sql);
        foreach ($admin_lang_list as $row) {
            $lang = $row['lang'];
            //语言
            if ($lang != 'en') {
                $path = $path_cn;
            } else {
                $path = $path_en;
            }

            //获取语言对照文件
            $lang_json = file_get_contents($path);
            $lang_data = json_decode($lang_json, true);

            if (is_array($lang_data)) {
                if (in_array($lang, array('cn', 'en'))) {
                    $sql = "DELETE FROM {$_M['table']['language']} WHERE lang = '{$lang}' AND  site = 1 AND app = 0 ";
                    DB::query($sql);
                    foreach ($lang_data as $lang_row) {
                        if ($lang_row['site'] == 1) {
                            self::add_language($lang_row);
                        }
                    }
                } else {
                    $query = "SELECT `id`,`name` FROM {$_M['table']['language']} WHERE lang = '{$lang}' AND site = '1'";
                    $admin_lang = DB::get_all($query);
                    $old_lang_index = array();
                    foreach ($admin_lang as $lang_item) {
                        $old_lang_index[] = $lang_item['name'];
                    }

                    $new_lang_index = array_keys($lang_data);
                    $diff_lang_idnex = array_diff($new_lang_index, $old_lang_index);

                    foreach ($diff_lang_idnex as $name) {
                        if ($lang_data[$name]['site'] == 1) {
                            self::add_language($lang_data[$name]);
                        }
                    }
                }
            }
        }
    }

    /**
     * 更新前台语言
     * @param $version
     */
    public function update_web_lang($version)
    {
        global $_M;
        //前台语言指纹
        $path_cn = PATH_WEB . "app/system/update/include/class/v{$version}lang_web_cn.json";
        $path_en = PATH_WEB . "app/system/update/include/class/v{$version}lang_web_en.json";

        $sql = "SELECT * FROM {$_M['table']['lang']} ";
        $web_lang_list = DB::get_all($sql);
        foreach ($web_lang_list as $row) {
            $lang = $row['lang'];
            //语言
            if ($lang != 'en') {
                $path = $path_cn;
            } else {
                $path = $path_en;
            }

            //获取语言对照文件
            $lang_json = file_get_contents($path);
            $lang_data = json_decode($lang_json, true);

            if (is_array($lang_data)) {
                $query = "SELECT `id`,`name` FROM {$_M['table']['language']} WHERE lang = '{$lang}' AND site = '0'";
                $web_lang = DB::get_all($query);

                $old_lang_index = array();
                foreach ($web_lang as $lang_item) {
                    $old_lang_index[] = $lang_item['name'];
                }

                $new_lang_index = array_keys($lang_data);
                $diff_lang_idnex = array_diff($new_lang_index, $old_lang_index);

                foreach ($diff_lang_idnex as $name) {
                    if ($lang_data[$name]['site'] == 0) {
                        self::add_language($lang_data[$name]);
                    }
                }

                //js语言
                $js_word = array('confirm', 'cancel');
                foreach ($js_word as $word) {
                    $sql = "UPDATE {$_M['table']['language']} SET app = 1 WHERE name = '{$word}' AND site = 0";
                    DB::query($sql);
                }
            }
        }
    }

    /**
     * 删除系统冗余文件
     */
    public function del_sys_file()
    {
        global $_M;
        $list = array(
            PATH_WEB . "app/app/ueditor/php",
            PATH_WEB . "app/static/modules/ueditor/php",
            PATH_WEB . "public/plugins/ueditor/php",
        );

        foreach ($list as $row) {
            if (is_dir($row)) {
                deldir($row);
            }
        }
    }

    /*****************************工具方法******************************/
    /**
     * 获取标准数据库文件
     * @return mixed
     */
    public function get_base_table()
    {
        global $_M;
        $json_sql = "https://www.metinfo.cn/upload/json/v{$this->version}mysql.json";
        $path = PATH_WEB . "app/system/update/include/class/v{$this->version}mysql.json";

        $table_json = file_get_contents($json_sql);
        if (!$table_json) {
            $table_json = self::curl($json_sql);
            if (!$table_json) {
                $table_json = file_get_contents($path);
            }
        }
        $base = json_decode($table_json, true);
        return $base;
    }

    /**
     * @param $json_sql
     * @return array
     */
    public function get_diff_tables()
    {
        global $_M;
        $tables = self::list_tables();
        $base = self::get_base_table();

        $baseTables = array_keys($base);
        $diffTables = array_diff($baseTables, $tables);

        $noTables = array();
        $data = array();
        foreach ($diffTables as $noTable) {
            $table_name = $noTable;
            $noTable = str_replace('met_', $_M['config']['tablepre'], $noTable);
            $data['table'][$noTable] = $base[$table_name];
            $noTables[] = $noTable;
        }

        foreach ($base as $table => $val) {
            if (!in_array($table, $noTables)) {
                $table = str_replace('met_', $_M['config']['tablepre'], $table);
                $fields = self::list_fields($table);
                $diff_field = array_diff_key($val, $fields);
                if ($diff_field) {
                    $data['field'][$table] = $diff_field;
                }
            }
        }
        return $data;
    }

    /**
     * @return array
     */
    public function list_tables()
    {
        global $_M;
        $query = "SHOW TABLE status";
        $tables = array();
        foreach (DB::get_all($query) as $key => $v) {
            $tables[] = str_replace($_M['config']['tablepre'], 'met_', $v['Name']);
        }
        return $tables;
    }

    /**
     * @param $table
     * @return array
     */
    public function list_fields($table)
    {
        global $_M;
        $query = "SHOW FULL FIELDS FROM {$table}";
        $fields = DB::get_all($query);
        $data = array();
        foreach ($fields as $key => $v) {
            $data[$v['Field']] = $v;
        }
        return $data;
    }

    /**
     * 新增配置
     * @param string $name
     * @param string $value
     * @param string $cid
     * @param string $lang
     */
    public function _insert_config($name = '', $value = '', $cid = '', $lang = '')
    {
        global $_M;
        $query = "SELECT id FROM {$_M['table']['config']} WHERE  name='{$name}' AND lang = '{$lang}'";
        $config = DB::get_one($query);
        if (!$config) {
            $query = "INSERT INTO {$_M['table']['config']} (name,value,mobile_value,columnid,flashid,lang)VALUES ('{$name}', '{$value}', '', '{$cid}', '0', '{$lang}')";
            DB::query($query);
        }
    }

    /**
     * 更新配置
     * @param string $name
     * @param string $value
     * @param string $cid
     * @param string $lang
     */
    public function _update_config($name = '', $value = '', $cid = '', $lang = '')
    {
        global $_M;
        $query = "SELECT id FROM {$_M['table']['config']} WHERE  name='{$name}' AND lang = '{$lang}'";
        $config = DB::get_one($query);
        if (!$config) {
            $query = "INSERT INTO {$_M['table']['config']} (name,value,mobile_value,columnid,flashid,lang)VALUES ('{$name}', '{$value}', '', '{$cid}', '0', '{$lang}')";
            DB::query($query);
        } else {
            $query = "UPDATE {$_M['table']['config']} SET name = '{$name}',value = '{$value}', columnid = '{$cid}' ,lang = '{$lang}' WHERE id = '{$config['id']}'";
            DB::query($query);
        }
    }

    /**
     * 更新 插入语言
     * @param array $lang_data
     */
    public function add_language($lang_data = array())
    {
        global $_M;
        $name = $lang_data['name'];
        $value = $lang_data['value'];
        $site = $lang_data['site'];
        $lang = $lang_data['lang'];
        $js = $lang_data['array'] ? 1 : 0;
        $app = $lang_data['app'];

        if ($site == 1) {
            $query = "INSERT INTO {$_M['table']['language']} SET name = '{$name}',value='{$value}',site = '{$site}',no_order = 0,array='{$js}', app = '{$app}', lang='{$lang}'";
            DB::query($query);
        }

        if ($site == 0) {
            $query = "INSERT INTO {$_M['table']['language']} SET name = '{$name}',value='{$value}',site = '{$site}',no_order = 0,array='{$js}', app = '{$app}', lang='{$lang}'";
            DB::query($query);
        }
        return;
    }

    /**
     * 获取sql
     * @param $data
     * @return string
     */
    public function get_sql($data)
    {
        global $_M;
        $sql = "";
        foreach ($data as $key => $value) {
            if (strstr($value, "'")) {
                $value = str_replace("'", "\'", $value);
            }
            $sql .= " {$key} = '{$value}',";
        }
        return trim($sql, ',');
    }

    /**
     * 获取三级栏目信息
     */
    public function getClass123($cid = '', $lang = '')
    {
        global $_M;
        $classnow = self::getClassById($cid, $lang);

        $return = array();
        if ($classnow) {
            if ($classnow['classtype'] == 1) {
                $return['class1'] = $classnow;
                $return['class2'] = array();
                $return['class3'] = array();
            }

            if ($classnow['classtype'] == 2) {
                $return['class1'] = self::getClassById($classnow['bigclass'], $lang);
                $return['class2'] = $classnow;
                $return['class3'] = array();
            }

            if ($classnow['classtype'] == 3) {
                $bigclass = self::getClassById($classnow['bigclass'], $lang);
                $return['class1'] = self::getClassById($bigclass['bigclass'], $lang);
                $return['class2'] = $bigclass;
                $return['class3'] = $classnow;
            }
            return $return;
        }
        return false;
    }

    /**
     * 获取特定栏目信息
     * @param string $cid
     * @param string $lang
     * @return array|bool
     */
    public function getClassById($cid = '', $lang = '')
    {
        global $_M;
        if ($cid && $lang) {
            $query = "SELECT * FROM {$_M['table']['column']} WHERE lang = '{$lang}' AND id = '{$cid}'";
            $class = DB::get_one($query);
            return $class;
        }
        return false;
    }

    /**
     * 获取栏目配置
     * @param $class_id
     * @return array
     */
    public function getClassConfig($class_id = '')
    {
        global $_M;
        $query = "SELECT * FROM {$_M['table']['config']} WHERE columnid = '{$class_id}'";
        $config_list = DB::get_all($query);
        $list = array();
        foreach ($config_list as $key => $val) {
            $list[$val['name']] = $val['value'];
        }
        return $list;
    }

    /**
     * CURL
     */
    protected function curl($url = '', $data = array(), $timeout = 30)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POST, 0);
        #curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

    //不要删除该方法
    public function check($pid = '')
    {
    }
}