<?php
# MetInfo Enterprise Content Management System
# Copyright (C) MetInfo Co.,Ltd (http://www.metinfo.cn). All rights reserved.

defined('IN_MET') or exit('No permission');

/**
 *  数据处理基类.
 */
class handle
{
    /**
     * 系统保留目录
     * @return array
     */
    public function sys_folders()
    {
        $modfile = array('app', 'admin', 'about', 'news', 'product', 'download', 'img', 'job', 'cache', 'config', 'install', 'feedback', 'include', 'lang', 'link', 'member', 'message', 'public', 'search', 'sitemap', 'templates', 'upload', 'wap', 'online', 'hits', 'shop', 'pay', 'tags', 'tag', '');
        return $modfile;
    }

    /**
     * 根据模块编号，返回栏目列表遍文件名称.
     * @param $mod
     * @return string
     */
    public function mod_to_name($mod)
    {
        global $_M;
        switch ($mod) {
            case '1':
                $name = 'show';
                break;
            case '2':
                $name = 'news';
                break;
            case '3':
                $name = 'product';
                break;
            case '4':
                $name = 'download';
                break;
            case '5':
                $name = 'img';
                break;
            case '6':
                $name = 'job';
                break;
            case '7':
                $name = 'message';
                break;
            case '8':
                $name = 'feedback';
                break;
            case '9':
                $name = 'link';
                break;
            case '10':
                $name = 'member';
                break;
            case '11':
                $name = 'search';
                break;
            case '12':
                $name = 'sitemap';
                break;
            case '13':
                $name = 'tags';
                break;
            default:
                $name = '';
                break;
        }

        return $name;
    }

    /**
     * 根据模块编号，返回栏目列表遍文件名称.
     * @param $mod
     * @return string
     */
    public function mod_to_file($mod)
    {
        global $_M;
        switch ($mod) {
            case '1':
                $name = 'about';
                break;
            case '2':
                $name = 'news';
                break;
            case '3':
                $name = 'product';
                break;
            case '4':
                $name = 'download';
                break;
            case '5':
                $name = 'img';
                break;
            case '6':
                $name = 'job';
                break;
            case '7':
                $name = 'message';
                break;
            case '8':
                $name = 'feedback';
                break;
            case '9':
                $name = 'link';
                break;
            case '10':
                $name = 'member';
                break;
            case '11':
                $name = 'search';
                break;
            case '12':
                $name = 'sitemap';
                break;
            case '13':
                $name = 'tags';
                break;
            default:
                $name = '';
                break;
        }

        return $name;
    }

    /**
     * 根据模块编号，返回栏目列表遍文件名称.
     * @param $file
     * @return string
     */
    public function file_to_mod($file)
    {
        global $_M;
        switch ($file) {
            case 'about':
                $mod = '1';
                break;
            case 'news':
                $mod = '2';
                break;
            case 'product':
                $mod = '3';
                break;
            case 'download':
                $mod = '4';
                break;
            case 'img':
                $mod = '5';
                break;
            case 'job':
                $mod = '6';
                break;
            case 'message':
                $mod = '7';
                break;
            case 'feedback':
                $mod = '8';
                break;
            case 'link':
                $mod = '9';
                break;
            case 'member':
                $mod = '10';
                break;
            case 'search':
                $mod = '11';
                break;
            case 'sitemap':
                $mod = '12';
                break;
            case 'tags':
                $mod = '13';
                break;
            default:
                $mod = '';
                break;
        }

        return $mod;
    }

    /**
     * 统一全站Url路径
     * @param string $url
     * @param string $lang
     * @return string
     */
    public function url_transform($url = '', $lang = '')
    {
        global $_M;
        $lang = $lang ?: $_M['lang'];
        $url = trim($url);
        $web_site = $_M['url']['web_site'];
        $lang_site = $_M['langlist']['web'][$lang]['link'] ?: "";
        $_url = str_replace(array($lang_site, $web_site, '../'), '', $url);

        if (strtolower(substr($_url, 0, 4)) == 'http') return $url;  //外链
        $site = defined('IN_ADMIN') ? $web_site : $_M['url']['site'];
        if (defined("IS_SITEMAP")) {    //网站地图
            $site = $lang_site ?: $web_site;
        }
        $_url = $site . $_url;

        //可视化
        if ($_M['form']['pageset']) {
            if (strstr($_url, '?')) {
                $_url .= '&pageset=1';
            } elseif (substr($_url, -1) == '/') {
                $_url .= "index.php?lang={$_M['lang']}&pageset=1";
            }
        }
        return $_url;
    }

    /**
     * url类型.
     *
     * @param string $url_type 链接类型（1:动态，2:伪静态，3:静态）
     * @param string $page_type 页面类型（2:分页，1:列表页面，0:内容页面）
     * @param string $pseudo 伪静态  0关闭|1开启
     * @param string $webhtm 静态  0关闭静态|1首页、内容页面静态化|2全站静态
     *
     * @return int|string 链接类型（1:动态，2:伪静态，3:静态）
     */
    public function url_type($url_type = '', $page_type = '', $pseudo = '', $webhtm = '')
    {
        global $_M;
        if (isset($_M['form']['page']) && $_M['form']['page']) {
            $_page = true;
        }

        //可视化前置动态
        if ($_M['form']['pageset']) {
            return 1;
        }

        //搜索状态下，列表页强制动态
        if ($_M['form']['search'] && $page_type == 2) {
            return 1;
        }

        //指定URL_TYPE
        if ($url_type) {
            return $url_type;
        }

        //伪静态
        if ($pseudo) {
            return 2;
        } else {
            if ($_M['config']['met_pseudo']) {
                return 2;
            }
        }

        //静态配置
        if (!$webhtm) {//0关闭静态|1首页、内容页面静态化|2全站静态|3混合模式
            $webhtm = $_M['config']['met_webhtm'];
        }

        //page_type页面类型（2:分页，1:列表页面，0:内容页面）
        if ($page_type) {//列表页
            if ($webhtm) {
                switch ($webhtm) {
                    case 1: //1首页、内容页面静态化
                        $url_type = 1;
                        break;
                    case 2: //2全站静态
                        $url_type = 3;
                        break;
                    case 3: //3混合模式
                        if ($_page === true) {
                            $url_type = 2;
                        }else{
                            $url_type = 3;
                        }
                        break;
                }
            } else {//动态
                $url_type = 1;
            }
        } else {//内容页
            if (!$webhtm) {
                $url_type = 1;
            } else {
                $url_type = 3;
            }
        }

        return $url_type;
    }

    /**
     * @param  string  $module      模块名称或者模块编号
     * @return string               模块名称编号数组
   */
    public function handle_module($module)
    {
        global $_M;
        if (is_numeric($module)) {
            return array(
                'num' => $module,
                'name' => $this->mod_to_file($module),
            );
        } else {
            return array(
                'num' => $this->file_to_mod($module),
                'name' => $module,
            );
        }
    }

    /**
     * @param string $url
     * @param int $page
     * @param int $class
     * @param string $type
     * @return mixed
     */
    public function replace_list_page_url($url = '', $page = 1, $class = 0, $type = '')
    {
        global $_M;
        if ($page == 1 && $class && !$_M['form']['search']) {
            $c = load::sys_class('label', 'new')->get('column')->get_column_id($class);
            return load::sys_class('label', 'new')->get('column')->handle->url_full($c, $type);
        } else {
            //tag搜索列表首页
            if ($page == 1 && $_M['form']['search'] == 'tag' && $_M['config']['met_pseudo']) {
                return str_replace('-#page#', '', $url);
            }
            return str_replace('#page#', $page, $url);
        }
    }

    /**
     * 替换资源相对路径.
     * @param string $content
     * @return mixed
     */
    public function replace_relative_url($content = '')
    {
        global $_M;
        $new_content = str_replace('../', $_M['url']['site'], $content);

        return $new_content;
    }

    /**
     * 伪静态、静态页跳转
     * @param array $data
     */
    public function redirectUrl($data = array())
    {
        global $_M;
        if ($_M['form']['mituo'] == 1) return;
        if (!$data['url']) return;

        if (
            $_M['form']['search'] == 'tag' &&
            strstr(REQUEST_URI, '.php') &&
            ($_M['config']['met_pseudo'] || $_M['config']['met_webhtm'] == 3)
        ) {
            if ($data['module'] == 11) {
                // 如果是标签的全站搜索，伪静态时跳转
                header('HTTP/1.1 302 Moved Permanently');
                header("Location: ../tag/{$_M['form']['searchword']}");
                die;
            } else {
                header('HTTP/1.1 302 Moved Permanently');
                header("Location: ./tag/{$_M['form']['content']}");
                die;
            }
        }

        if (
            strstr(REQUEST_URI, '.php') &&
            !defined('IN_ADMIN') &&
            !$_M['form']['pageset'] &&
            !$_M['form']['search'] &&
            ($_M['config']['met_pseudo'] || $_M['config']['met_webhtm']) &&
            !$_M['form']['metinfonow'] &&
            !isset($_M['form']['para']) &&
            !isset($_M['form']['searchword'])
        ) {
            if ($_M['config']['met_webhtm'] == 1 && $data['list']) return;
            if (strstr($data['url'],'.php')) return;

            header('HTTP/1.1 302 Moved Permanently');
            header("Location: {$data['url']}");
            die;
        }
    }

    /**
     * @param string $site_url
     * @return array
     */
    public function checkFunction($site_url = '')
    {
        global $_M;
        if (!$site_url) {
            $site_url = $_M['url']['web_site'];
        }

        $items = array();
        //函数
        $items[] = array('mysqli_connect', 'danger', '支持', '函数未开启，网站程序无法使用mysql数据库', 'func');
        $items[] = array('file_get_contents', 'danger', '支持', '系统无法远程获取内容，会导致有些操作不起作用或数据不显示<a href="https://www.mituo.cn/qa/2461.html" target="_blank">[帮助]</a>', 'func');
        $items[] = array('file_put_contents', 'danger', '支持', '系统无法写文件<a href="https://www.mituo.cn/qa/2462.html" target="_blank">[帮助]</a>', 'func');
        $items[] = array('parse_ini_file', 'danger', '支持', '无法连接数据库<a href="https://www.mituo.cn/qa/2463.html" target="_blank">[帮助]</a>', 'func');
        $items[] = array('fopen', 'danger', '支持', '系统无法打开操作文件<a href="https://www.mituo.cn/qa/2460.html" target="_blank">[帮助]</a>', 'func');
        $items[] = array('fsockopen', 'danger', '支持', '无法自动更新静态文件<a href="https://www.mituo.cn/qa/" target="_blank">[帮助]</a>', 'func');
        $items[] = array('mb_strlen', 'danger', '支持', '函数未开启，会导致前台显示不完整<a href="https://www.mituo.cn/qa" target="_blank">[帮助]</a>', 'func');
        $items[] = array('bccomp', 'danger', '支持', '函数未开启，会导致支付回调失效<a href="https://www.mituo.cn/qa" target="_blank">[帮助]</a>', 'func');
        $items[] = array('copy', 'danger', '支持', '无法上传或复制文件<a href="https://www.mituo.cn/qa/2465.html" target="_blank">[帮助]</a>', 'func');
        $items[] = array('rename', 'danger', '支持', '无法重命名文件<a href="https://www.mituo.cn/qa/2464.html" target="_blank">[帮助]</a>', 'func');
        $items[] = array('unlink', 'danger', '支持', '函数未开启，无法清除缓存<a href="https://www.mituo.cn/qa/2467.html" target="_blank">[帮助]</a>', 'func');
        $items[] = array('opendir', 'danger', '支持', '无法列出目录下文件', 'func');
        $items[] = array('scandir', 'danger', '支持', '无法列出目录下文件<a href="https://www.mituo.cn/qa/2466.html" target="_blank">[帮助]</a>', 'func');
        $items[] = array('curl_exec', 'danger', '支持', '系统无法远程获取内容，会导致有些操作不起作用或数据不显示<a href="https://www.mituo.cn/qa/2468.html" target="_blank">[帮助]</a>', 'func');
        $items[] = array('json_decode', 'danger', '支持', '函数未开启，会导致接口数据解析失败，模板安装失败<a href="https://www.mituo.cn/qa/" target="_blank">[帮助]</a>', 'func');
        $items[] = array('json_encode', 'danger', '支持', '函数未开启，无法构造json字符串<a href="https://www.mituo.cn/qa/" target="_blank">[帮助]</a>', 'func');
        if ($_M['config']['db_type'] == 'dmsql') {
            $items[] = array('dm_connect', 'danger', '支持', '不支持达梦数据库连接<a href="https://www.mituo.cn/qa/" target="_blank">[帮助]</a>', 'func');
        }

        //PHP扩展
        $items[] = array('zip', 'danger', '支持', '无法在线解压ZIP文件。（无法通过后台上传模板和数据备份文件）<a href="https://www.mituo.cn/qa" target="_blank">[帮助]</a>', 'model');
            $items[] = array('curl', 'danger', '支持', '系统无法远程获取内容，会导致有些操作不起作用或数据不显示<a href="https://www.mituo.cn/qa/2450.html" target="_blank">[帮助]</a>', 'model');
            $items[] = array('bcmath', 'danger', '支持', '会导致支付回调失效<a href="https://www.mituo.cn/qa" target="_blank">[帮助]</a>', 'model');
            $items[] = array('gd', 'danger', '支持', '图片打水印和缩略生成功能无法使用<a href="https://www.mituo.cn/qa/2453.html" target="_blank">[帮助]</a>', 'model');
            $items[] = array('dom', 'danger', '支持', 'DOM扩展库未正常开启<a href="https://www.mituo.cn/qa/" target="_blank">[帮助]</a>', 'model');

        //环境配置
        $items[] = array('file_uploads', 'danger', '支持', '无法上传文件<a href="https://www.mituo.cn/qa/2456.html" target="_blank">[帮助]</a>', 'setup');
            $items[] = array('smtp', 'warning', '支持', '系统邮件功能无法使用<a href="https://www.mituo.cn/qa/2469.html" target="_blank">[帮助]</a>', 'smtp');
            $items[] = array('woff2', 'warning', '支持', '不支持该文件类型<a href="https://www.mituo.cn/qa/2446.html" target="_blank">[帮助]</a>', 'woff2');
            $items[] = array('PHP', 'danger', PHP_VERSION, 'php版本需要在5.3到8.3之间，否则无法安装使用程序', 'php');
            $OPENSSL_VERSION_TEXT = defined('OPENSSL_VERSION_TEXT') ? OPENSSL_VERSION_TEXT : null;
            $items[] = array('openssl', 'warning', $OPENSSL_VERSION_TEXT, $OPENSSL_VERSION_TEXT . '模块未开启，无法发送邮件，且部分应用插件无法使用（如官方商城、一键导入微信文章等）<a href="https://www.mituo.cn/qa/2449.html" target="_blank">[帮助]</a>', 'openssl');

        if (stristr($_SERVER['SERVER_SOFTWARE'], 'Apache')) {
            $items[] = array('伪静态', 'warning', '支持', '伪静态无法生效', 'apache');
        }
        if (!defined('IN_ADMIN')) {
            //$items[] = array('session', 'danger', '支持', '会话session不可用<a href="https://www.mituo.cn/qa/2667.html" target="_blank">[帮助]</a>', 'session');
        } else {
            $items[] = array('SQLite3', 'warning', '支持', '无法使用sqlite数据库，请到php.ini中开启', 'class');
        }

        foreach ($items as &$v) {
            $yes = true;
            switch ($v[4]) {
                case 'model':
                    $yes = extension_loaded($v[0]);
                    break;
                case 'func':
                    $yes = function_exists($v[0]);
                    break;
                case 'class':
                    $yes = class_exists($v[0]);
                    break;
                case 'setup':
                    $yes = ini_get($v[0]);
                    break;
                case 'openssl':
                    $yes = defined('OPENSSL_VERSION_TEXT') ? strstr($OPENSSL_VERSION_TEXT, '1.') : 'null';
                    break;
                case 'php':
                    $yes = version_compare(PHP_VERSION, '5.3.0', '>') && version_compare(PHP_VERSION, '8.3.0', '<');
                    break;
                case 'session':
                    //$yes = is_writable(session_save_path());
                    if (session_status() !== PHP_SESSION_DISABLED) {
                        $yes = true;
                    }
                    break;
                case 'apache':
                    $mod = 'mod_rewrite';
                    if (function_exists('apache_get_modules')) {
                        $yes = in_array($mod, apache_get_modules());
                    } else {
                        if (function_exists('phpinfo')) {
                            ob_start();
                            phpinfo();
                            $phpinfo = ob_get_clean();
                            if (false !== strpos($phpinfo, $mod)) {
                                $yes = true;
                            }
                        }
                    }
                    break;
                case 'smtp':
                    $yes = function_exists('fsockopen') || function_exists('pfsockopen') || function_exists('stream_socket_client');
                    break;
                case 'woff2':
                    $yes = @file_get_contents('../public/fonts/font-awesome/metinfo-icon1.woff2');
                    break;
            }

            if (!$yes) {
                $v[2] = $v[3];
            } else {
                $v[1] = 'success';
            }
        }

        return $items;
    }

    /**
     * @return array
     */
    public function checkDirs()
    {
        global $_M;
        $dirs = array(
            '../about/',
            '../download/',
            '../product/',
            '../news/',
            '../img/',
            '../job/',
            '../sitemap/',
            '../upload/',
            '../tags/',
            '../config/',
            '../config/config_db.php',
            '../config/config_safe.php',
            '../cache/',
            '../upload/file/',
            '../message/',
            '../feedback/',
            '../app/',
            '../app/system/',
            /*'../templates/metv7/cache/',
            '../admin/databack/',*/
        );

        if ($_M['config']['met_adminfile']) {
            $dirs[] = "../{$_M['config']['met_adminfile']}/databack/";
        } else {
            $dirs[] = '../admin/databack/';
        }

        if ($_M['config']['met_skin_user']) {
            $dirs[] = "../templates/{$_M['config']['met_skin_user']}/cache/";
        }

        $data = array();
        foreach ($dirs as $key => $row) {
            if (!strstr($row, '.php')) {
                if (!file_exists($row)) {
                    mkdir($row, 0777, true);
                }
            }
            $data[$key]['dir'] = $row;

            if (!file_exists($row)) {
                $data[$key]['msg'] = '文件或文件夹不存在请上传';
                $data[$key]['status'] = 'danger';
            } elseif (!is_writable($row) && version_compare(PHP_VERSION, '5.4') >= 0) {
                $data[$key]['msg'] .= '777属性检测不通过';
                $data[$key]['status'] = 'danger';
            } else {
                $data[$key]['msg'] .= '通 过';
                $data[$key]['status'] = 'success';
            }
        }

        return $data;
    }
}

# This program is an open source system, commercial use, please consciously to purchase commercial license.
# Copyright (C) MetInfo Co., Ltd. (http://www.metinfo.cn). All rights reserved.
